<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model 
{

    protected $table = 'sub_categories';
    public $timestamps = true;
    protected $fillable = array('name', 'category_id');

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function skills()
    {
        return $this->hasMany('App\Models\Skill', 'sub_category_id');
    }

    public function courses()
    {
        return $this->hasMany('App\Models\Course');
    }

}